(*********************************************************)
(*      Delphi for .NET File Viewer demo                 *)
(*      Written by:  Chua Chee Wee, Singapore            *)
(*      chuacw@rightsecurity.biz                         *)
(*      Right Security Consultants                       *)
(*      http://www.rightsecurity.biz                     *)
(*                                                       *)
(*********************************************************)
program FileViewer;


{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Design.dll'}
{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Windows.Forms.dll'}

uses
  System.Windows.Forms,
  System.Drawing,
  System.ComponentModel,
  System.Collections,
  System.IO,
  System.ComponentModel.Design,
  Classes,
  SysUtils,
  System.Reflection,
  System.Diagnostics;

[assembly: AssemblyTitle('File Viewer')]
[assembly: AssemblyDescription('File Viewer for .NET')]
[assembly: AssemblyCompany('Right Security Consultants, Singapore')]
[assembly: AssemblyCopyright('')]
[assembly: AssemblyVersion('1.0.*')]

type

  TByteViewer = System.ComponentModel.Design.ByteViewer;

  TMenuItem = class(System.Windows.Forms.MenuItem)
  public
    constructor Create;
  end;

  TfrmFileViewer = class(System.Windows.Forms.Form)
    Label1: System.Windows.Forms.Label;
    MainMenu1: System.Windows.Forms.MainMenu;
    miFile: TMenuItem;
    miFileOpen: TMenuItem;
    N1: TMenuItem;
    miFileExit: TMenuItem;
    miView: TMenuItem;
    miViewAuto: TMenuItem;
    miViewAnsi: TMenuItem;
    miViewHex: TMenuItem;
    miViewUnicode: TMenuItem;
    Viewer: TByteViewer;
    VScrollBar: System.Windows.Forms.ScrollBar;
    procedure ViewAutoClick(Sender: TObject; e: EventArgs);
    procedure ViewAnsiClick(Sender: TObject; e: EventArgs);
    procedure ViewHexClick(Sender: TObject; e: EventArgs);
    procedure ViewUnicodeClick(Sender: TObject; e: EventArgs);
    procedure FileOpenClick(Sender: TObject; e: EventArgs);
    procedure FileCloseClick(Sender: TObject; e: EventArgs);
    procedure LoadViewerFile(const AFilename: string='');
  protected
    { Private declarations }
    procedure InitState;
    procedure FormResize(Sender: TObject; e: EventArgs);
    procedure UncheckAll;
    procedure SetFile(const Filename: string);
  public
    { Public declarations }
    constructor Create;
  end;

var
  frmFileViewer: TfrmFileViewer;

constructor TMenuItem.Create;
begin
  inherited Create;
  RadioCheck := True;
end;

constructor TfrmFileViewer.Create;
begin
  inherited;
  InitState;
end;

procedure TfrmFileViewer.LoadViewerFile(const AFilename: string='');
begin
 if (AFilename='') or (AFilename=nil) then
  SetFile(ParamStr(0)) else
  SetFile(AFilename);
end;

procedure TfrmFileViewer.InitState;
begin

  MaximumSize := System.Drawing.Size.Create(640, 519);
  MinimumSize := MaximumSize;

  Text := 'File Viewer';

  Viewer := TByteViewer.Create;
  Viewer.Dock := System.Windows.Forms.DockStyle.Fill;
  AutoScroll := True;

  Controls.Add(Viewer);

  MainMenu1 := System.Windows.Forms.MainMenu.Create;
  miFile := TMenuItem.Create;
  miFileOpen := TMenuItem.Create;
  N1 := TMenuItem.Create;
  miFileExit := TMenuItem.Create;

  miView := TMenuItem.Create;
  miView.Enabled := False;

  miViewAuto := TMenuItem.Create;
  miViewAnsi := TMenuItem.Create;
  miViewHex := TMenuItem.Create;
  miViewUnicode := TMenuItem.Create;

  with MainMenu1 do
  begin
    Name := 'MainMenu1';
    Left := 78;
    Top := 14;
  end;
  with miFile do
  begin
    Name := 'File1';
    Text := 'File';
  end;
  with miFileOpen do
  begin
    Name := 'Open1';
    Text := 'Open...';
    add_click(FileOpenClick);
  end;
  with N1 do
  begin
    Name := 'N1';
    Text := '-';
  end;
  with miFileExit do
  begin
    Name := 'Exit1';
    Text := 'E&xit';
    add_click(FileCloseClick);
  end;
  with miView do
  begin
    Name := 'View1';
    Text := 'View';
  end;
  with miViewAuto do
  begin
    Name := 'Auto1';
    Text := 'Auto';
    add_click(ViewAutoClick);
  end;
  with miViewAnsi do
  begin
    Name := 'Ansi1';
    Text := '&Ansi';
    add_click(ViewAnsiClick);
  end;
  with miViewHex do
  begin
    Name := 'Hex1';
    Text := '&Hex';
    add_click(ViewHexClick);
  end;
  with miViewUnicode do
  begin
    Name := 'Unicode1';
    Text := '&Unicode';
    add_click(ViewUnicodeClick);
  end;

  MainMenu1.MenuItems.Add(miFile);
  miFile.MenuItems.Add(miFileOpen);
  miFile.MenuItems.Add(N1);
  miFile.MenuItems.Add(miFileExit);

  MainMenu1.MenuItems.Add(miView);
  miView.MenuItems.Add(miViewAuto);
  miView.MenuItems.Add(miViewAnsi);
  miView.MenuItems.Add(miViewHex);
  miView.MenuItems.Add(miViewUnicode);

  miViewAuto.Checked := True;

  Menu := MainMenu1;

  if ParamCount=0 then
   LoadViewerFile(ParamStr(0)) else
   LoadViewerFile(ParamStr(1));
end;

procedure TfrmFileViewer.FormResize(Sender: TObject; e: EventArgs);
begin
  Viewer.Dock := System.Windows.Forms.DockStyle.Fill;
  Viewer.Update;
end;

procedure TfrmFileViewer.FileOpenClick(Sender: TObject; e: EventArgs);
var
 OpenDialog: OpenFileDialog;
begin
 OpenDialog := OpenFileDialog.Create;
 OpenDialog.Filter := 'All files (*.*)|*.*';
 if OpenDialog.ShowDialog=System.Windows.Forms.DialogResult.Ok then
   begin
    SetFile(OpenDialog.Filename);
   end;
end;

procedure TfrmFileViewer.FileCloseClick(Sender: TObject; e: EventArgs);
begin
 Close;
end;

procedure TfrmFileViewer.ViewAutoClick(Sender: TObject; e: EventArgs);
begin
 UncheckAll;
 miViewAuto.Checked := True;
 try // will throw exception if nothing/no file has been displayed/loaded.
  Viewer.SetDisplayMode(DisplayMode.Auto);
 except
 end;
end;

procedure TfrmFileViewer.ViewAnsiClick(Sender: TObject; e: EventArgs);
begin
 UncheckAll;
 miViewAnsi.Checked := True;
 try
  Viewer.SetDisplayMode(DisplayMode.Ansi);
 except
 end;
end;

procedure TfrmFileViewer.ViewHexClick(Sender: TObject; e: EventArgs);
begin
 UncheckAll;
 miViewHex.Checked := True;
 try
  Viewer.SetDisplayMode(DisplayMode.Hexdump);
 except
 end;
end;

procedure TfrmFileViewer.ViewUnicodeClick(Sender: TObject; e: EventArgs);
begin
 UncheckAll;
 miViewUnicode.Checked := True;
 try
  Viewer.SetDisplayMode(DisplayMode.Unicode);
 except
 end;
end;

procedure TfrmFileViewer.UncheckAll;
begin
 miViewAuto.Checked := False;
 miViewAnsi.Checked := False;
 miViewHex.Checked := False;
 miViewUnicode.Checked := False;
end;

procedure TfrmFileViewer.SetFile(const Filename: string);
begin
  Viewer.SetFile(Filename);
  Text := Format('File Viewer - %s', [Filename]);
  miView.Enabled := True;
end;

begin
  Application.EnableVisualStyles;
  frmFileViewer := TfrmFileViewer.Create;
  Application.Run(frmFileViewer);
end.
